/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.component.DecompileData;
import ghidra.app.decompiler.component.DecompilerManager;
import ghidra.app.decompiler.component.EmptyDecompileData;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.UndefinedFunction;
import ghidra.util.task.SwingRunnable;
import ghidra.util.task.TaskMonitor;
import java.io.File;

class DecompileRunnable
implements SwingRunnable {
    private volatile Function functionToDecompile;
    private final Program program;
    private ProgramLocation location;
    private File debugFile;
    private DecompileResults decompileResults;
    private String errorMessage;
    private ViewerPosition viewerPosition;
    private final DecompilerManager decompilerManager;

    public DecompileRunnable(Program program, ProgramLocation location, File debugFile, ViewerPosition viewerPosition, DecompilerManager decompilerManager) {
        this.program = program;
        this.location = location;
        this.debugFile = debugFile;
        this.viewerPosition = viewerPosition;
        this.decompilerManager = decompilerManager;
    }

    public boolean update(DecompileRunnable newRunnable) {
        Program newProgram = newRunnable.program;
        ProgramLocation newLocation = newRunnable.location;
        if (!this.matches(newProgram, newLocation)) {
            return false;
        }
        this.location = newLocation;
        ViewerPosition newPosition = newRunnable.viewerPosition;
        if (newPosition != null) {
            this.viewerPosition = newPosition;
        }
        return true;
    }

    private boolean matches(Program otherProgram, ProgramLocation otherLocation) {
        if (this.functionToDecompile == null) {
            return false;
        }
        if (this.program != otherProgram) {
            return false;
        }
        if (otherLocation.getAddress() == null) {
            return true;
        }
        return this.functionToDecompile.getBody().contains(otherLocation.getAddress());
    }

    public void monitoredRun(TaskMonitor monitor) {
        monitor.setIndeterminate(true);
        Function function = this.findFunction(monitor);
        if (function == null) {
            return;
        }
        CodeUnit cu = this.program.getListing().getCodeUnitAt(function.getEntryPoint());
        if (cu instanceof Data && ((Data)cu).isDefined()) {
            return;
        }
        monitor.setMessage("Decompiling function: " + function.getName() + "...");
        this.functionToDecompile = function;
        try {
            this.decompileResults = this.decompilerManager.decompile(this.program, this.functionToDecompile, this.debugFile, monitor);
        }
        catch (DecompileException e) {
            this.errorMessage = e.getMessage();
        }
    }

    public void swingRun(boolean isCancelled) {
        if (isCancelled) {
            this.decompilerManager.setDecompileData(this, new EmptyDecompileData("Decompile Cancelled."));
        } else {
            DecompileData decompileData = new DecompileData(this.program, this.functionToDecompile, this.location, this.decompileResults, this.errorMessage, this.debugFile, this.viewerPosition);
            this.decompilerManager.setDecompileData(this, decompileData);
        }
    }

    private Function findFunction(TaskMonitor monitor) {
        Function realFunction;
        if (this.program == null || this.location == null) {
            return null;
        }
        Address address = this.location.getAddress();
        if (address == null) {
            return null;
        }
        if (monitor.isCancelled()) {
            return null;
        }
        Function function = this.program.getFunctionManager().getFunctionContaining(address);
        if (function != null) {
            return function;
        }
        function = UndefinedFunction.findFunction((Program)this.program, (Address)address, (TaskMonitor)monitor);
        if (function != null && (realFunction = this.program.getFunctionManager().getFunctionAt(function.getEntryPoint())) != null) {
            return realFunction;
        }
        return function;
    }
}

