/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.data;

import ghidra.framework.data.DefaultProjectData;
import ghidra.framework.data.GhidraFolder;
import ghidra.framework.data.GhidraFolderData;
import ghidra.framework.data.RootGhidraFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.store.FileSystem;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;

public class RootGhidraFolderData
extends GhidraFolderData {
    private HashMap<String, Integer> folderReferenceCounts = new HashMap();

    RootGhidraFolderData(DefaultProjectData projectData, DomainFolderChangeListener listener) {
        super(projectData, listener);
    }

    @Override
    GhidraFolder getDomainFolder() {
        return new RootGhidraFolder(this.getProjectData(), this.getChangeListener());
    }

    void setVersionedFileSystem(FileSystem fs) {
        this.versionedFileSystem = fs;
    }

    @Override
    boolean privateExists() {
        return true;
    }

    @Override
    boolean sharedExists() {
        return true;
    }

    public boolean mustVisit(String folderPathname) {
        return this.folderReferenceCounts.containsKey(folderPathname);
    }

    void registerInternalLinkPath(String absoluteLinkPath) {
        if (!absoluteLinkPath.startsWith(FileSystem.SEPARATOR)) {
            throw new IllegalArgumentException();
        }
        String[] pathSplit = absoluteLinkPath.split(FileSystem.SEPARATOR);
        int folderElementCount = pathSplit.length - 1;
        GhidraFolderData folderData = this;
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 1; i < folderElementCount; ++i) {
            String folderName = pathSplit[i];
            if (folderName.length() == 0) continue;
            if (folderData != null && (folderData = folderData.getFolderData(folderName, false)) != null && !folderData.visited()) {
                try {
                    folderData.refresh(false, true, TaskMonitor.DUMMY);
                }
                catch (IOException e) {
                    folderData = null;
                }
            }
            pathBuilder.append(FileSystem.SEPARATOR);
            pathBuilder.append(folderName);
            this.folderReferenceCounts.compute(pathBuilder.toString(), (path, count) -> {
                int n;
                if (count == null) {
                    n = 1;
                } else {
                    count = count + 1;
                    n = count;
                }
                return n;
            });
        }
    }

    void unregisterInternalLinkPath(String absoluteLinkPath) {
        if (!absoluteLinkPath.startsWith(FileSystem.SEPARATOR)) {
            throw new IllegalArgumentException();
        }
        String[] pathSplit = absoluteLinkPath.split(FileSystem.SEPARATOR);
        int folderElementCount = pathSplit.length - 1;
        StringBuilder pathBuilder = new StringBuilder();
        for (int i = 1; i < folderElementCount; ++i) {
            String folderName = pathSplit[i];
            if (folderName.length() == 0) continue;
            pathBuilder.append(FileSystem.SEPARATOR);
            pathBuilder.append(folderName);
            String path = pathBuilder.toString();
            Integer count = this.folderReferenceCounts.get(path);
            if (count == null) continue;
            if (count == 1) {
                this.folderReferenceCounts.remove(path);
                continue;
            }
            this.folderReferenceCounts.put(path, count - 1);
        }
    }
}

