/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.navigation;

import ghidra.app.nav.NavigationUtils;
import ghidra.app.plugin.core.gotoquery.GoToHelper;
import ghidra.app.services.QueryData;
import ghidra.app.util.navigation.SymbolMatcher;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.util.ProgramLocation;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;

public class SymbolSearcher {
    private SymbolMatcher symbolMatcher;
    private QueryData queryData;
    private int limit;
    private TaskMonitor monitor;

    public SymbolSearcher(QueryData data, int limit, TaskMonitor monitor) {
        this.queryData = data;
        this.limit = limit;
        this.monitor = monitor;
        this.symbolMatcher = new SymbolMatcher(this.queryData.getQueryString(), this.queryData.isCaseSensitive());
    }

    public List<ProgramLocation> findMatchingSymbolLocations(List<Program> searchPrograms) {
        ArrayList<ProgramLocation> locations = new ArrayList<ProgramLocation>();
        for (Program program : searchPrograms) {
            if (this.monitor.isCancelled()) break;
            if (!this.findMatchingSymbolLocations(program, locations)) continue;
            return locations;
        }
        return locations;
    }

    private boolean findMatchingSymbolLocations(Program program, List<ProgramLocation> locations) {
        if (!this.findSymbolsByDirectLookup(program, locations)) {
            this.findSymbolsByBruteForce(program, locations);
        }
        return !locations.isEmpty();
    }

    private boolean findSymbolsByDirectLookup(Program program, List<ProgramLocation> locations) {
        if (!this.symbolMatcher.hasFullySpecifiedName()) {
            return false;
        }
        String symbolName = this.symbolMatcher.getSymbolName();
        return this.scanSymbols(program, program.getSymbolTable().getSymbols(symbolName), locations);
    }

    private void findSymbolsByBruteForce(Program program, List<ProgramLocation> locations) {
        if (!this.symbolMatcher.hasFullySpecifiedName()) {
            this.searchDefinedSymbols(program, locations);
        }
        if (this.queryData.isIncludeDynamicLables()) {
            this.searchDynamicSymbolsByReference(program, locations);
        }
    }

    private void searchDynamicSymbolsByReference(Program program, List<ProgramLocation> locations) {
        if (!this.symbolMatcher.hasWildCardsInSymbolName()) {
            this.parseDynamic(program, locations);
            return;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        ReferenceManager refMgr = program.getReferenceManager();
        AddressSet addressSet = program.getAddressFactory().getAddressSet();
        AddressIterator addrIt = refMgr.getReferenceDestinationIterator((AddressSetView)addressSet, true);
        while (addrIt.hasNext() && locations.size() < this.limit) {
            if (this.monitor.isCancelled()) {
                return;
            }
            Address addr = addrIt.next();
            Symbol s = symbolTable.getPrimarySymbol(addr);
            if (!s.isDynamic()) continue;
            this.addSymbolIfMatches(s, locations);
        }
    }

    private boolean addSymbolIfMatches(Symbol s, List<ProgramLocation> locations) {
        if (this.symbolMatcher.matches(s)) {
            ProgramLocation programLocation = this.getProgramLocationForSymbol(s);
            if (programLocation != null) {
                locations.add(programLocation);
                return true;
            }
            return this.addExternalLinkageLocations(s, locations);
        }
        return false;
    }

    private boolean addExternalLinkageLocations(Symbol symbol, List<ProgramLocation> locations) {
        Address[] externalLinkageAddresses;
        boolean addedLocations = false;
        Program program = symbol.getProgram();
        for (Address address : externalLinkageAddresses = NavigationUtils.getExternalLinkageAddresses(program, symbol.getAddress())) {
            ProgramLocation location = GoToHelper.getProgramLocationForAddress(address, program);
            if (location == null) continue;
            addedLocations = true;
            locations.add(location);
        }
        return addedLocations;
    }

    private void parseDynamic(Program program, List<ProgramLocation> locations) {
        String symbolName;
        AddressFactory addressFactory = program.getAddressFactory();
        Address address = SymbolUtilities.parseDynamicName((AddressFactory)addressFactory, (String)(symbolName = this.symbolMatcher.getSymbolName()));
        if (address == null) {
            return;
        }
        Symbol s = program.getSymbolTable().getPrimarySymbol(address);
        if (s != null && s.isDynamic()) {
            this.addSymbolIfMatches(s, locations);
        }
    }

    private void searchDefinedSymbols(Program program, List<ProgramLocation> locations) {
        String symbolName = this.symbolMatcher.getSymbolName();
        SymbolTable symbolTable = program.getSymbolTable();
        SymbolIterator it = symbolTable.getSymbolIterator(symbolName, this.queryData.isCaseSensitive());
        this.scanSymbols(program, it, locations);
    }

    private boolean scanSymbols(Program program, SymbolIterator it, List<ProgramLocation> locations) {
        boolean addedSymbols = false;
        while (it.hasNext() && locations.size() < this.limit && !this.monitor.isCancelled()) {
            Symbol symbol = it.next();
            addedSymbols |= this.addSymbolIfMatches(symbol, locations);
        }
        return addedSymbols;
    }

    private ProgramLocation getProgramLocationForSymbol(Symbol symbol) {
        Address symbolAddress = symbol.getAddress();
        if (symbolAddress.isExternalAddress()) {
            return null;
        }
        Memory memory = symbol.getProgram().getMemory();
        if (symbolAddress.isMemoryAddress() && !memory.contains(symbolAddress)) {
            return null;
        }
        return symbol.getProgramLocation();
    }
}

