/*
 * gedit-app-activatable.h
 * This file is part of gedit
 *
 * Copyright (C) 2010 - Steve Frécinaux
 * Copyright (C) 2010 - Jesse van den Kieboom
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Library General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#ifndef GEDIT_APP_ACTIVATABLE_H
#define GEDIT_APP_ACTIVATABLE_H

#include <glib-object.h>
#include <gedit/gedit-menu-extension.h>

G_BEGIN_DECLS

#define GEDIT_TYPE_APP_ACTIVATABLE (gedit_app_activatable_get_type ())

G_DECLARE_INTERFACE (GeditAppActivatable, gedit_app_activatable, GEDIT, APP_ACTIVATABLE, GObject)

/**
 * GeditAppActivatableInterface:
 * @parent_interface: The parent interface.
 * @activate: The virtual function pointer for gedit_app_activatable_activate().
 * @deactivate: The virtual function pointer for
 *   gedit_app_activatable_deactivate().
 *
 * The virtual function table for #GeditAppActivatable.
 */
struct _GeditAppActivatableInterface
{
	GTypeInterface parent_interface;

	void	(*activate)	(GeditAppActivatable *activatable);

	void	(*deactivate)	(GeditAppActivatable *activatable);
};

void			gedit_app_activatable_activate		(GeditAppActivatable *activatable);

void			gedit_app_activatable_deactivate	(GeditAppActivatable *activatable);

GeditMenuExtension *	gedit_app_activatable_extend_menu	(GeditAppActivatable *activatable,
								 const gchar         *extension_point);

G_END_DECLS

#endif /* GEDIT_APP_ACTIVATABLE_H */
/* ex:set ts=8 noet: */
