﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kinesisanalyticsv2/KinesisAnalyticsV2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace KinesisAnalyticsV2 {
namespace Model {

/**
 * <p>Provides a description of Amazon CloudWatch logging options, including the
 * log stream Amazon Resource Name (ARN). </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/kinesisanalyticsv2-2018-05-23/CloudWatchLoggingOption">AWS
 * API Reference</a></p>
 */
class CloudWatchLoggingOption {
 public:
  AWS_KINESISANALYTICSV2_API CloudWatchLoggingOption() = default;
  AWS_KINESISANALYTICSV2_API CloudWatchLoggingOption(Aws::Utils::Json::JsonView jsonValue);
  AWS_KINESISANALYTICSV2_API CloudWatchLoggingOption& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_KINESISANALYTICSV2_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the CloudWatch log to receive application messages.</p>
   */
  inline const Aws::String& GetLogStreamARN() const { return m_logStreamARN; }
  inline bool LogStreamARNHasBeenSet() const { return m_logStreamARNHasBeenSet; }
  template <typename LogStreamARNT = Aws::String>
  void SetLogStreamARN(LogStreamARNT&& value) {
    m_logStreamARNHasBeenSet = true;
    m_logStreamARN = std::forward<LogStreamARNT>(value);
  }
  template <typename LogStreamARNT = Aws::String>
  CloudWatchLoggingOption& WithLogStreamARN(LogStreamARNT&& value) {
    SetLogStreamARN(std::forward<LogStreamARNT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_logStreamARN;
  bool m_logStreamARNHasBeenSet = false;
};

}  // namespace Model
}  // namespace KinesisAnalyticsV2
}  // namespace Aws
