﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/rolesanywhere/RolesAnywhere_EXPORTS.h>
#include <aws/rolesanywhere/model/CrlDetail.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace RolesAnywhere {
namespace Model {
class DeleteCrlResult {
 public:
  AWS_ROLESANYWHERE_API DeleteCrlResult() = default;
  AWS_ROLESANYWHERE_API DeleteCrlResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ROLESANYWHERE_API DeleteCrlResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The state of the certificate revocation list (CRL) after a read or write
   * operation.</p>
   */
  inline const CrlDetail& GetCrl() const { return m_crl; }
  template <typename CrlT = CrlDetail>
  void SetCrl(CrlT&& value) {
    m_crlHasBeenSet = true;
    m_crl = std::forward<CrlT>(value);
  }
  template <typename CrlT = CrlDetail>
  DeleteCrlResult& WithCrl(CrlT&& value) {
    SetCrl(std::forward<CrlT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DeleteCrlResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  CrlDetail m_crl;

  Aws::String m_requestId;
  bool m_crlHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace RolesAnywhere
}  // namespace Aws
