/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyFunctionType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PySyntheticCallHelper {
    private PySyntheticCallHelper() {
    }

    public static PyType getCallType(@NotNull PyFunction function, @Nullable PyType receiverType, @NotNull List<PyType> argumentTypes, @NotNull TypeEvalContext context) {
        if (function == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(0);
        }
        if (argumentTypes == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(2);
        }
        return PySyntheticCallHelper.getCallTypeOnTypesOnly(function, receiverType, argumentTypes, context);
    }

    @Nullable
    public static PyType getCallTypeByFunctionName(@NotNull String functionName, @NotNull PyType receiverType, @NotNull List<PyType> argumentTypes, @NotNull TypeEvalContext context) {
        List<PyFunction> functions;
        if (functionName == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(3);
        }
        if (receiverType == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(4);
        }
        if (argumentTypes == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(5);
        }
        if (context == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(6);
        }
        if ((functions = PySyntheticCallHelper.resolveFunctionsByArgumentTypes(functionName, argumentTypes, receiverType, context)).isEmpty()) {
            return null;
        }
        return (PyType)StreamEx.of(functions).nonNull().map(function -> PySyntheticCallHelper.getCallTypeOnTypesOnly(function, receiverType, argumentTypes, context)).collect(PyTypeUtil.toUnion());
    }

    @Nullable
    private static PyType getCallTypeOnTypesOnly(@NotNull PyFunction function, @Nullable PyType receiverType, @NotNull List<PyType> arguments, @NotNull TypeEvalContext context) {
        PyType type;
        if (function == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(7);
        }
        if (arguments == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(9);
        }
        if ((type = context.getType((PyTypedElement)function)) instanceof PyFunctionType) {
            PyFunctionType functionType = (PyFunctionType)type;
            SyntheticCallArgumentsMapping argumentsMapping = PySyntheticCallHelper.mapArgumentsOnTypes(arguments, functionType, context);
            Map<Ref<PyType>, PyCallableParameter> actualParameters = argumentsMapping.getMappedParameters();
            List allParameters = ContainerUtil.notNullize((List)function.getParameters(context));
            PyType returnType = functionType.getReturnType(context);
            return PySyntheticCallHelper.analyzeCallTypeOnTypesOnly(returnType, actualParameters, allParameters, receiverType, context);
        }
        return null;
    }

    @NotNull
    static List<PyFunction> resolveFunctionsByArgumentTypes(@NotNull String functionName, @NotNull List<PyType> argumentTypes, @Nullable PyType receiverType, @NotNull TypeEvalContext context) {
        if (functionName == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(10);
        }
        if (argumentTypes == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(11);
        }
        if (context == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(12);
        }
        return PySyntheticCallHelper.matchOverloadsByArgumentTypes(PySyntheticCallHelper.resolveFunctionsByName(functionName, receiverType, context), argumentTypes, receiverType, context);
    }

    @NotNull
    private static List<PyFunction> resolveFunctionsByName(@NotNull String functionName, @Nullable PyType receiverType, @NotNull TypeEvalContext context) {
        if (functionName == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(14);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
        List members = Collections.emptyList();
        if (receiverType instanceof PyCallableType) {
            members = receiverType.resolveMember(functionName, null, AccessDirection.READ, resolveContext);
        }
        if (members == null || members.isEmpty()) {
            List<PyFunction> list = Collections.emptyList();
            if (list == null) {
                PySyntheticCallHelper.$$$reportNull$$$0(15);
            }
            return list;
        }
        List resolvedFunctions = StreamEx.of((Collection)members).map(RatedResolveResult::getElement).select(PyFunction.class).toList();
        if (resolvedFunctions.isEmpty()) {
            List<PyFunction> list = Collections.emptyList();
            if (list == null) {
                PySyntheticCallHelper.$$$reportNull$$$0(16);
            }
            return list;
        }
        List list = resolvedFunctions;
        if (list == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(17);
        }
        return list;
    }

    @NotNull
    private static List<PyFunction> matchOverloadsByArgumentTypes(@NotNull List<PyFunction> functions, @NotNull List<PyType> argumentTypes, @Nullable PyType receiverType, @NotNull TypeEvalContext context) {
        PyFunction firstFunc;
        if (functions == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(18);
        }
        if (argumentTypes == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(20);
        }
        if ((firstFunc = (PyFunction)ContainerUtil.getFirstItem(functions)) != null && PyiUtil.isOverload((PsiElement)firstFunc, context)) {
            boolean someArgumentsHaveUnknownType;
            List matchingOverloads = ContainerUtil.filter(functions, function -> PyiUtil.isOverload((PsiElement)function, context) && PySyntheticCallHelper.matchesByArgumentTypesOnTypesOnly(function, receiverType, argumentTypes, context));
            if (matchingOverloads.isEmpty()) {
                List<PyFunction> list = Collections.emptyList();
                if (list == null) {
                    PySyntheticCallHelper.$$$reportNull$$$0(21);
                }
                return list;
            }
            if (matchingOverloads.size() > 1 && (someArgumentsHaveUnknownType = ContainerUtil.exists(argumentTypes, arg -> arg == null))) {
                List list = matchingOverloads;
                if (list == null) {
                    PySyntheticCallHelper.$$$reportNull$$$0(22);
                }
                return list;
            }
            List<PyFunction> list = List.of((PyFunction)matchingOverloads.get(0));
            if (list == null) {
                PySyntheticCallHelper.$$$reportNull$$$0(23);
            }
            return list;
        }
        List<PyFunction> list = functions;
        if (list == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(24);
        }
        return list;
    }

    @Nullable
    private static PyType analyzeCallTypeOnTypesOnly(@Nullable PyType type, @NotNull Map<Ref<PyType>, PyCallableParameter> actualParameters, @NotNull Collection<PyCallableParameter> allParameters, @Nullable PyType receiverType, @NotNull TypeEvalContext context) {
        if (actualParameters == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(25);
        }
        if (allParameters == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(27);
        }
        PyTypeChecker.GenericSubstitutions substitutions = PyTypeChecker.unifyGenericCallOnArgumentTypes(receiverType, actualParameters, context);
        PyTypeChecker.GenericSubstitutions substitutionsWithUnresolvedReturnGenerics = PyTypeChecker.getSubstitutionsWithUnresolvedReturnGenerics(allParameters, type, substitutions, context);
        return PyTypeChecker.substitute(type, substitutionsWithUnresolvedReturnGenerics, context);
    }

    @NotNull
    private static SyntheticCallArgumentsMapping mapArgumentsOnTypes(@NotNull List<PyType> arguments, @NotNull PyFunctionType functionType, @NotNull TypeEvalContext context) {
        List parameters;
        if (arguments == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(28);
        }
        if (functionType == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(29);
        }
        if (context == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(30);
        }
        if ((parameters = functionType.getParameters(context)) == null) {
            SyntheticCallArgumentsMapping syntheticCallArgumentsMapping = SyntheticCallArgumentsMapping.empty((PyCallableType)functionType);
            if (syntheticCallArgumentsMapping == null) {
                PySyntheticCallHelper.$$$reportNull$$$0(31);
            }
            return syntheticCallArgumentsMapping;
        }
        int safeImplicitOffset = Math.min(functionType.getImplicitOffset(), parameters.size());
        List explicitParameters = parameters.subList(safeImplicitOffset, parameters.size());
        List<PyCallableParameter> implicitParameters = parameters.subList(0, safeImplicitOffset);
        List<PyType> unmappedArguments = arguments.subList(Math.min(explicitParameters.size(), arguments.size()), arguments.size());
        HashMap<Ref<PyType>, PyCallableParameter> mappedParams = new HashMap<Ref<PyType>, PyCallableParameter>();
        for (int i = 0; i < explicitParameters.size(); ++i) {
            if (i >= arguments.size()) continue;
            mappedParams.put((Ref<PyType>)Ref.create((Object)arguments.get(i)), (PyCallableParameter)explicitParameters.get(i));
        }
        return new SyntheticCallArgumentsMapping((PyCallableType)functionType, implicitParameters, mappedParams, unmappedArguments);
    }

    private static boolean matchesByArgumentTypesOnTypesOnly(@NotNull PyFunction callable, @Nullable PyType receiverType, @NotNull List<PyType> arguments, @NotNull TypeEvalContext context) {
        PyType functionType;
        if (callable == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(32);
        }
        if (arguments == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(33);
        }
        if (context == null) {
            PySyntheticCallHelper.$$$reportNull$$$0(34);
        }
        if (!((functionType = context.getType((PyTypedElement)callable)) instanceof PyFunctionType)) {
            return false;
        }
        SyntheticCallArgumentsMapping fullMapping = PySyntheticCallHelper.mapArgumentsOnTypes(arguments, (PyFunctionType)functionType, context);
        if (!fullMapping.getUnmappedArguments().isEmpty()) {
            return false;
        }
        LinkedHashMap<Ref<PyType>, PyCallableParameter> allMappedParameters = new LinkedHashMap<Ref<PyType>, PyCallableParameter>();
        PyCallableParameter firstImplicit = (PyCallableParameter)ContainerUtil.getFirstItem(fullMapping.getImplicitParameters());
        if (firstImplicit != null) {
            allMappedParameters.put(Ref.create((Object)receiverType), firstImplicit);
        }
        allMappedParameters.putAll(fullMapping.getMappedParameters());
        return PyTypeChecker.unifyGenericCallOnArgumentTypes(receiverType, allMappedParameters, context) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 16, 17, 21, 22, 23, 24, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentTypes";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 14: 
            case 20: 
            case 27: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 8: 
            case 28: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PySyntheticCallHelper";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functions";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualParameters";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allParameters";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PySyntheticCallHelper";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFunctionsByName";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "matchOverloadsByArgumentTypes";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "mapArgumentsOnTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCallTypeByFunctionName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCallTypeOnTypesOnly";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionsByArgumentTypes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionsByName";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 31: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "matchOverloadsByArgumentTypes";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "analyzeCallTypeOnTypesOnly";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "mapArgumentsOnTypes";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "matchesByArgumentTypesOnTypesOnly";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 16, 17, 21, 22, 23, 24, 31 -> new IllegalStateException(string);
        };
    }

    private static class SyntheticCallArgumentsMapping {
        @Nullable
        private final PyCallableType myReceiverType;
        @NotNull
        private final List<PyCallableParameter> myImplicitParameters;
        @NotNull
        private final List<PyType> myUnmappedArguments;
        @NotNull
        private final Map<Ref<PyType>, PyCallableParameter> myMappedParameters;

        SyntheticCallArgumentsMapping(@Nullable PyCallableType receiverType, @NotNull List<PyCallableParameter> implicitParameters, @NotNull Map<Ref<PyType>, PyCallableParameter> mappedParameters, @NotNull List<PyType> unmappedArguments) {
            if (implicitParameters == null) {
                SyntheticCallArgumentsMapping.$$$reportNull$$$0(0);
            }
            if (mappedParameters == null) {
                SyntheticCallArgumentsMapping.$$$reportNull$$$0(1);
            }
            if (unmappedArguments == null) {
                SyntheticCallArgumentsMapping.$$$reportNull$$$0(2);
            }
            this.myReceiverType = receiverType;
            this.myImplicitParameters = implicitParameters;
            this.myMappedParameters = mappedParameters;
            this.myUnmappedArguments = unmappedArguments;
        }

        @NotNull
        List<PyCallableParameter> getImplicitParameters() {
            List<PyCallableParameter> list = this.myImplicitParameters;
            if (list == null) {
                SyntheticCallArgumentsMapping.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        Map<Ref<PyType>, PyCallableParameter> getMappedParameters() {
            Map<Ref<PyType>, PyCallableParameter> map = this.myMappedParameters;
            if (map == null) {
                SyntheticCallArgumentsMapping.$$$reportNull$$$0(4);
            }
            return map;
        }

        @NotNull
        private List<PyType> getUnmappedArguments() {
            List<PyType> list = this.myUnmappedArguments;
            if (list == null) {
                SyntheticCallArgumentsMapping.$$$reportNull$$$0(5);
            }
            return list;
        }

        @Nullable
        PyCallableType getReceiverType() {
            return this.myReceiverType;
        }

        @NotNull
        public static SyntheticCallArgumentsMapping empty(@NotNull PyCallableType receiverType) {
            if (receiverType == null) {
                SyntheticCallArgumentsMapping.$$$reportNull$$$0(6);
            }
            return new SyntheticCallArgumentsMapping(receiverType, Collections.emptyList(), Collections.emptyMap(), Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "implicitParameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mappedParameters";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unmappedArguments";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/psi/types/PySyntheticCallHelper$SyntheticCallArgumentsMapping";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "receiverType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/psi/types/PySyntheticCallHelper$SyntheticCallArgumentsMapping";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImplicitParameters";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMappedParameters";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnmappedArguments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "empty";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

