/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller.ifile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.HarFs;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.io.compress.Compressor;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.file.tfile.BoundedRangeFileInputStream;
import org.apache.hadoop.io.file.tfile.Compression;
import org.apache.hadoop.io.file.tfile.SimpleBufferedOutputStream;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.org.apache.commons.lang3.SerializationUtils;
import org.apache.hadoop.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogAggregationType;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.LogAggregationUtils;
import org.apache.hadoop.yarn.logaggregation.LogToolUtils;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.ifile.IndexedFileAggregatedLogsBlock;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.Times;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class LogAggregationIndexedFileController
extends LogAggregationFileController {
    private static final Logger LOG = LoggerFactory.getLogger(LogAggregationIndexedFileController.class);
    private static final String FS_OUTPUT_BUF_SIZE_ATTR = "indexedFile.fs.output.buffer.size";
    private static final String FS_INPUT_BUF_SIZE_ATTR = "indexedFile.fs.input.buffer.size";
    private static final String FS_NUM_RETRIES_ATTR = "indexedFile.fs.op.num-retries";
    private static final String FS_RETRY_INTERVAL_MS_ATTR = "indexedFile.fs.retry-interval-ms";
    private static final String LOG_ROLL_OVER_MAX_FILE_SIZE_GB = "indexedFile.log.roll-over.max-file-size-gb";
    private static final int LOG_ROLL_OVER_MAX_FILE_SIZE_GB_DEFAULT = 10;
    @VisibleForTesting
    public static final String CHECK_SUM_FILE_SUFFIX = "-checksum";
    private int fsNumRetries = 3;
    private long fsRetryInterval = 1000L;
    private static final int VERSION = 1;
    private IndexedLogsMeta indexedLogsMeta = null;
    private IndexedPerAggregationLogMeta logsMetaInThisCycle;
    private long logAggregationTimeInThisCycle;
    private FSDataOutputStream fsDataOStream;
    private Compression.Algorithm compressAlgo;
    private CachedIndexedLogsMeta cachedIndexedLogsMeta = null;
    private boolean logAggregationSuccessfullyInThisCyCle = false;
    private long currentOffSet = 0L;
    private Path remoteLogCheckSumFile;
    private FileContext fc;
    private UserGroupInformation ugi;
    private byte[] uuid = null;
    private final int UUID_LENGTH = 32;
    private long logRollOverMaxFileSize;
    private Clock sysClock;

    @Override
    public void initInternal(Configuration conf) {
        String compressName = conf.get("yarn.nodemanager.log-aggregation.compression-type", "none");
        this.compressAlgo = Compression.getCompressionAlgorithmByName(compressName);
        this.fsNumRetries = conf.getInt(FS_NUM_RETRIES_ATTR, 3);
        this.fsRetryInterval = conf.getLong(FS_RETRY_INTERVAL_MS_ATTR, 1000L);
        this.logRollOverMaxFileSize = this.getRollOverLogMaxSize(conf);
        this.sysClock = this.getSystemClock();
    }

    @Override
    public void initializeWriter(final LogAggregationFileControllerContext context) throws IOException {
        final UserGroupInformation userUgi = context.getUserUgi();
        final Map<ApplicationAccessType, String> appAcls = context.getAppAcls();
        final String nodeId = context.getNodeId().toString();
        final ApplicationId appId = context.getAppId();
        final Path remoteLogFile = context.getRemoteNodeLogFileForApp();
        this.ugi = userUgi;
        this.logAggregationSuccessfullyInThisCyCle = false;
        this.logsMetaInThisCycle = new IndexedPerAggregationLogMeta();
        this.logAggregationTimeInThisCycle = this.sysClock.getTime();
        this.logsMetaInThisCycle.setUploadTimeStamp(this.logAggregationTimeInThisCycle);
        this.logsMetaInThisCycle.setRemoteNodeFile(remoteLogFile.getName());
        try {
            userUgi.doAs(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    boolean createdNew;
                    LogAggregationIndexedFileController.this.fc = FileContext.getFileContext(LogAggregationIndexedFileController.this.remoteRootLogDir.toUri(), LogAggregationIndexedFileController.this.conf);
                    LogAggregationIndexedFileController.this.fc.setUMask(APP_LOG_FILE_UMASK);
                    if (LogAggregationIndexedFileController.this.indexedLogsMeta == null) {
                        LogAggregationIndexedFileController.this.indexedLogsMeta = new IndexedLogsMeta();
                        LogAggregationIndexedFileController.this.indexedLogsMeta.setVersion(1);
                        LogAggregationIndexedFileController.this.indexedLogsMeta.setUser(userUgi.getShortUserName());
                        LogAggregationIndexedFileController.this.indexedLogsMeta.setAcls(appAcls);
                        LogAggregationIndexedFileController.this.indexedLogsMeta.setNodeId(nodeId);
                        String compressName = LogAggregationIndexedFileController.this.conf.get("yarn.nodemanager.log-aggregation.compression-type", "none");
                        LogAggregationIndexedFileController.this.indexedLogsMeta.setCompressName(compressName);
                    }
                    Path aggregatedLogFile = null;
                    Pair initializationResult = null;
                    if (context.isLogAggregationInRolling()) {
                        initializationResult = LogAggregationIndexedFileController.this.initializeWriterInRolling(remoteLogFile, appId, nodeId);
                        aggregatedLogFile = (Path)initializationResult.getLeft();
                        createdNew = (Boolean)initializationResult.getRight();
                    } else {
                        aggregatedLogFile = remoteLogFile;
                        LogAggregationIndexedFileController.this.fsDataOStream = LogAggregationIndexedFileController.this.fc.create(remoteLogFile, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                        if (LogAggregationIndexedFileController.this.uuid == null) {
                            LogAggregationIndexedFileController.access$802(LogAggregationIndexedFileController.this, LogAggregationIndexedFileController.this.createUUID(appId));
                        }
                        LogAggregationIndexedFileController.this.fsDataOStream.write(LogAggregationIndexedFileController.this.uuid);
                        LogAggregationIndexedFileController.this.fsDataOStream.flush();
                        createdNew = true;
                    }
                    if (createdNew) {
                        LogAggregationIndexedFileController.this.currentOffSet = 0L;
                    } else {
                        long aggregatedLogFileLength = LogAggregationIndexedFileController.this.fc.getFileStatus(aggregatedLogFile).getLen();
                        byte[] dummyBytes = "\n".getBytes(Charset.forName("UTF-8"));
                        LogAggregationIndexedFileController.this.fsDataOStream.write(dummyBytes);
                        LogAggregationIndexedFileController.this.fsDataOStream.flush();
                        if (LogAggregationIndexedFileController.this.fsDataOStream.getPos() < aggregatedLogFileLength + (long)dummyBytes.length) {
                            LogAggregationIndexedFileController.this.currentOffSet = LogAggregationIndexedFileController.this.fc.getFileStatus(aggregatedLogFile).getLen();
                        } else {
                            LogAggregationIndexedFileController.this.currentOffSet = 0L;
                        }
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<Path, Boolean> initializeWriterInRolling(Path remoteLogFile, ApplicationId appId, String nodeId) throws Exception {
        boolean createdNew = false;
        Path aggregatedLogFile = null;
        if (this.uuid == null) {
            this.uuid = this.loadUUIDFromLogFile(this.fc, remoteLogFile.getParent(), appId, nodeId);
        }
        Path currentRemoteLogFile = this.getCurrentRemoteLogFile(this.fc, remoteLogFile.getParent(), nodeId);
        boolean overwriteCheckSum = true;
        this.remoteLogCheckSumFile = new Path(remoteLogFile.getParent(), remoteLogFile.getName() + CHECK_SUM_FILE_SUFFIX);
        if (this.fc.util().exists(this.remoteLogCheckSumFile)) {
            this.indexedLogsMeta.getLogMetas().clear();
            if (currentRemoteLogFile != null) {
                FSDataInputStream checksumFileInputStream;
                block10: {
                    checksumFileInputStream = null;
                    try {
                        String recoveredLogFile;
                        checksumFileInputStream = this.fc.open(this.remoteLogCheckSumFile);
                        int nameLength = checksumFileInputStream.readInt();
                        byte[] b = new byte[nameLength];
                        int actualLength = checksumFileInputStream.read(b);
                        if (actualLength != nameLength || !(recoveredLogFile = new String(b, Charset.forName("UTF-8"))).equals(currentRemoteLogFile.getName())) break block10;
                        overwriteCheckSum = false;
                        long endIndex = checksumFileInputStream.readLong();
                        IndexedLogsMeta recoveredLogsMeta = this.loadIndexedLogsMeta(currentRemoteLogFile, endIndex, appId);
                        if (recoveredLogsMeta == null) break block10;
                        this.indexedLogsMeta = recoveredLogsMeta;
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanupWithLogger(LOG, checksumFileInputStream);
                        throw throwable;
                    }
                }
                IOUtils.cleanupWithLogger(LOG, checksumFileInputStream);
            }
        }
        if (currentRemoteLogFile == null || this.isRollover(this.fc, currentRemoteLogFile)) {
            this.indexedLogsMeta.getLogMetas().clear();
            overwriteCheckSum = true;
            aggregatedLogFile = new Path(remoteLogFile.getParent(), remoteLogFile.getName() + "_" + this.sysClock.getTime());
            this.fsDataOStream = this.fc.create(aggregatedLogFile, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
            this.fsDataOStream.write(this.uuid);
            this.fsDataOStream.flush();
            createdNew = true;
        } else {
            aggregatedLogFile = currentRemoteLogFile;
            this.fsDataOStream = this.fc.create(currentRemoteLogFile, EnumSet.of(CreateFlag.CREATE, CreateFlag.APPEND), new Options.CreateOpts[0]);
        }
        if (overwriteCheckSum) {
            long currentAggregatedLogFileLength = createdNew ? 0L : this.fc.getFileStatus(aggregatedLogFile).getLen();
            FSDataOutputStream checksumFileOutputStream = null;
            try {
                checksumFileOutputStream = this.fc.create(this.remoteLogCheckSumFile, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[0]);
                String fileName = aggregatedLogFile.getName();
                checksumFileOutputStream.writeInt(fileName.length());
                checksumFileOutputStream.write(fileName.getBytes(Charset.forName("UTF-8")));
                checksumFileOutputStream.writeLong(currentAggregatedLogFileLength);
                checksumFileOutputStream.flush();
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(LOG, checksumFileOutputStream);
                throw throwable;
            }
            IOUtils.cleanupWithLogger(LOG, checksumFileOutputStream);
        }
        return Pair.of((Object)aggregatedLogFile, (Object)createdNew);
    }

    @Override
    public void closeWriter() {
        IOUtils.cleanupWithLogger(LOG, this.fsDataOStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(AggregatedLogFormat.LogKey logKey, AggregatedLogFormat.LogValue logValue) throws IOException {
        String containerId = logKey.toString();
        Set<File> pendingUploadFiles = logValue.getPendingLogFilesToUploadForThisContainer();
        ArrayList<IndexedFileLogMeta> metas = new ArrayList<IndexedFileLogMeta>();
        for (File logFile : pendingUploadFiles) {
            FileInputStream in = null;
            try {
                in = SecureIOUtils.openForRead(logFile, logValue.getUser(), null);
            }
            catch (IOException e) {
                LogAggregationIndexedFileController.logErrorMessage(logFile, e);
                IOUtils.cleanupWithLogger(LOG, in);
                continue;
            }
            long fileLength = logFile.length();
            IndexedFileOutputStreamState outputStreamState = null;
            try {
                long newLength;
                outputStreamState = new IndexedFileOutputStreamState(this.compressAlgo, this.fsDataOStream, this.conf, this.currentOffSet);
                byte[] buf = new byte[65535];
                int len = 0;
                long bytesLeft = fileLength;
                while ((len = in.read(buf)) != -1) {
                    if ((long)len < bytesLeft) {
                        outputStreamState.getOutputStream().write(buf, 0, len);
                        bytesLeft -= (long)len;
                        continue;
                    }
                    outputStreamState.getOutputStream().write(buf, 0, (int)bytesLeft);
                    break;
                }
                if (fileLength < (newLength = logFile.length())) {
                    LOG.warn("Aggregated logs truncated by approximately " + (newLength - fileLength) + " bytes.");
                }
                this.logAggregationSuccessfullyInThisCyCle = true;
            }
            catch (IOException e) {
                block11: {
                    try {
                        String message = LogAggregationIndexedFileController.logErrorMessage(logFile, e);
                        if (outputStreamState == null || outputStreamState.getOutputStream() == null) break block11;
                        outputStreamState.getOutputStream().write(message.getBytes(Charset.forName("UTF-8")));
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanupWithLogger(LOG, in);
                        throw throwable;
                    }
                }
                IOUtils.cleanupWithLogger(LOG, in);
            }
            IOUtils.cleanupWithLogger(LOG, in);
            IndexedFileLogMeta meta = new IndexedFileLogMeta();
            meta.setContainerId(containerId.toString());
            meta.setFileName(logFile.getName());
            if (outputStreamState != null) {
                outputStreamState.finish();
                meta.setFileCompressedSize(outputStreamState.getCompressedSize());
                meta.setStartIndex(outputStreamState.getStartPos());
                meta.setFileSize(fileLength);
            }
            meta.setLastModifiedTime(logFile.lastModified());
            metas.add(meta);
        }
        this.logsMetaInThisCycle.addContainerLogMeta(containerId, metas);
    }

    @Override
    public void postWrite(LogAggregationFileControllerContext record) throws Exception {
        this.indexedLogsMeta.addLogMeta(this.logsMetaInThisCycle);
        byte[] b = SerializationUtils.serialize((Serializable)this.indexedLogsMeta);
        this.fsDataOStream.write(b);
        int length = b.length;
        this.fsDataOStream.writeInt(length);
        this.fsDataOStream.write(this.uuid);
        if (this.logAggregationSuccessfullyInThisCyCle && record.isLogAggregationInRolling()) {
            this.deleteFileWithRetries(this.fc, this.ugi, this.remoteLogCheckSumFile);
        }
    }

    private void deleteFileWithRetries(final FileContext fileContext, final UserGroupInformation userUgi, final Path deletePath) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                LogAggregationIndexedFileController.this.deleteFileWithPrivilege(fileContext, userUgi, deletePath);
                return null;
            }
        }.runWithRetries();
    }

    private void deleteFileWithRetries(final FileContext fileContext, final Path deletePath) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                if (fileContext.util().exists(deletePath)) {
                    fileContext.delete(deletePath, false);
                }
                return null;
            }
        }.runWithRetries();
    }

    private void truncateFileWithRetries(final FileContext fileContext, final Path truncatePath, final long newLength) throws Exception {
        new FSAction<Void>(){

            @Override
            public Void run() throws Exception {
                fileContext.truncate(truncatePath, newLength);
                return null;
            }
        }.runWithRetries();
    }

    private Object deleteFileWithPrivilege(final FileContext fileContext, UserGroupInformation userUgi, final Path fileToDelete) throws Exception {
        return userUgi.doAs(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                if (fileContext.util().exists(fileToDelete)) {
                    fileContext.delete(fileToDelete, false);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readAggregatedLogs(ContainerLogsRequest logRequest, OutputStream os) throws IOException {
        String containerIdStr;
        boolean findLogs = false;
        boolean createPrintStream = os == null;
        ApplicationId appId = logRequest.getAppId();
        String nodeId = logRequest.getNodeId();
        String nodeIdStr = nodeId == null || nodeId.isEmpty() ? null : LogAggregationUtils.getNodeString(nodeId);
        ArrayList<String> logTypes = new ArrayList<String>();
        if (logRequest.getLogTypes() != null && !logRequest.getLogTypes().isEmpty()) {
            logTypes.addAll(logRequest.getLogTypes());
        }
        boolean getAllContainers = (containerIdStr = logRequest.getContainerId()) == null || containerIdStr.isEmpty();
        long size = logRequest.getBytes();
        RemoteIterator<FileStatus> nodeFiles = LogAggregationUtils.getRemoteNodeFileDir(this.conf, appId, logRequest.getAppOwner(), this.remoteRootLogDir, this.remoteRootLogDirSuffix);
        if (!nodeFiles.hasNext()) {
            throw new IOException("There is no available log file for application:" + appId);
        }
        List<FileStatus> allFiles = this.getAllNodeFiles(nodeFiles, appId);
        if (allFiles.isEmpty()) {
            throw new IOException("There is no available log file for application:" + appId);
        }
        Map<String, Long> checkSumFiles = this.parseCheckSumFiles(allFiles);
        List<FileStatus> fileToRead = this.getNodeLogFileToRead(allFiles, nodeIdStr, appId);
        byte[] buf = new byte[65535];
        for (FileStatus thisNodeFile : fileToRead) {
            String nodeName = thisNodeFile.getPath().getName();
            Long checkSumIndex = checkSumFiles.get(nodeName);
            long endIndex = -1L;
            if (checkSumIndex != null) {
                endIndex = checkSumIndex;
            }
            IndexedLogsMeta indexedLogsMeta = null;
            try {
                indexedLogsMeta = this.loadIndexedLogsMeta(thisNodeFile.getPath(), endIndex, appId);
            }
            catch (Exception ex) {
                LOG.warn("Can not load log meta from the log file:" + thisNodeFile.getPath() + "\n" + ex.getMessage());
                continue;
            }
            if (indexedLogsMeta == null) continue;
            String compressAlgo = indexedLogsMeta.getCompressName();
            ArrayList<IndexedFileLogMeta> candidates = new ArrayList<IndexedFileLogMeta>();
            for (IndexedPerAggregationLogMeta logMeta : indexedLogsMeta.getLogMetas()) {
                for (Map.Entry<String, List<IndexedFileLogMeta>> meta : logMeta.getLogMetas().entrySet()) {
                    for (IndexedFileLogMeta log : meta.getValue()) {
                        if (!getAllContainers && !log.getContainerId().equals(containerIdStr) || logTypes != null && !logTypes.isEmpty() && !logTypes.contains(log.getFileName())) continue;
                        candidates.add(log);
                    }
                }
            }
            if (candidates.isEmpty()) continue;
            Compression.Algorithm compressName = Compression.getCompressionAlgorithmByName(compressAlgo);
            Decompressor decompressor = compressName.getDecompressor();
            FileContext fileContext = FileContext.getFileContext(thisNodeFile.getPath().toUri(), this.conf);
            FSDataInputStream fsin = fileContext.open(thisNodeFile.getPath());
            String currentContainer = "";
            for (IndexedFileLogMeta candidate : candidates) {
                if (!candidate.getContainerId().equals(currentContainer) && createPrintStream) {
                    this.closePrintStream(os);
                    os = LogToolUtils.createPrintStream(logRequest.getOutputLocalDir(), thisNodeFile.getPath().getName(), candidate.getContainerId());
                    currentContainer = candidate.getContainerId();
                }
                InputStream in = null;
                try {
                    in = compressName.createDecompressionStream(new BoundedRangeFileInputStream(fsin, candidate.getStartIndex(), candidate.getFileCompressedSize()), decompressor, LogAggregationIndexedFileController.getFSInputBufferSize(this.conf));
                    LogToolUtils.outputContainerLog(candidate.getContainerId(), nodeName, candidate.getFileName(), candidate.getFileSize(), size, Times.format(candidate.getLastModifiedTime()), in, os, buf, ContainerLogAggregationType.AGGREGATED);
                    byte[] b = this.aggregatedLogSuffix(candidate.getFileName()).getBytes(Charset.forName("UTF-8"));
                    os.write(b, 0, b.length);
                    findLogs = true;
                }
                catch (IOException e) {
                    try {
                        System.err.println(e.getMessage());
                        compressName.returnDecompressor(decompressor);
                    }
                    catch (Throwable throwable) {
                        os.flush();
                        IOUtils.cleanupWithLogger(LOG, in);
                        throw throwable;
                    }
                    os.flush();
                    IOUtils.cleanupWithLogger(LOG, in);
                    continue;
                }
                os.flush();
                IOUtils.cleanupWithLogger(LOG, in);
            }
        }
        return findLogs;
    }

    @Override
    public List<ContainerLogMeta> readAggregatedLogsMeta(ContainerLogsRequest logRequest) throws IOException {
        ArrayList<IndexedLogsMeta> listOfLogsMeta = new ArrayList<IndexedLogsMeta>();
        ArrayList<ContainerLogMeta> containersLogMeta = new ArrayList<ContainerLogMeta>();
        String containerIdStr = logRequest.getContainerId();
        String nodeId = logRequest.getNodeId();
        ApplicationId appId = logRequest.getAppId();
        String appOwner = logRequest.getAppOwner();
        ApplicationAttemptId appAttemptId = logRequest.getAppAttemptId();
        boolean getAllContainers = containerIdStr == null || containerIdStr.isEmpty();
        String nodeIdStr = nodeId == null || nodeId.isEmpty() ? null : LogAggregationUtils.getNodeString(nodeId);
        RemoteIterator<FileStatus> nodeFiles = LogAggregationUtils.getRemoteNodeFileDir(this.conf, appId, appOwner, this.remoteRootLogDir, this.remoteRootLogDirSuffix);
        if (!nodeFiles.hasNext()) {
            throw new IOException("There is no available log file for application:" + appId);
        }
        List<FileStatus> allFiles = this.getAllNodeFiles(nodeFiles, appId);
        if (allFiles.isEmpty()) {
            throw new IOException("There is no available log file for application:" + appId);
        }
        Map<String, Long> checkSumFiles = this.parseCheckSumFiles(allFiles);
        List<FileStatus> fileToRead = this.getNodeLogFileToRead(allFiles, nodeIdStr, appId);
        for (FileStatus thisNodeFile : fileToRead) {
            try {
                Object current;
                Long checkSumIndex = checkSumFiles.get(thisNodeFile.getPath().getName());
                long endIndex = -1L;
                if (checkSumIndex != null) {
                    endIndex = checkSumIndex;
                }
                if ((current = this.loadIndexedLogsMeta(thisNodeFile.getPath(), endIndex, appId)) == null) continue;
                listOfLogsMeta.add((IndexedLogsMeta)current);
            }
            catch (IOException ex) {
                LOG.warn("Can not get log meta from the log file:" + thisNodeFile.getPath() + "\n" + ex.getMessage());
            }
        }
        for (IndexedLogsMeta indexedLogMeta : listOfLogsMeta) {
            String curNodeId = indexedLogMeta.getNodeId();
            for (IndexedPerAggregationLogMeta logMeta : indexedLogMeta.getLogMetas()) {
                if (getAllContainers) {
                    for (Map.Entry entry : logMeta.getLogMetas().entrySet()) {
                        String currentContainerIdStr = (String)entry.getKey();
                        if (appAttemptId != null && !this.belongsToAppAttempt(appAttemptId, currentContainerIdStr)) continue;
                        ContainerLogMeta meta = new ContainerLogMeta((String)entry.getKey(), curNodeId);
                        for (IndexedFileLogMeta aMeta : (List)entry.getValue()) {
                            meta.addLogMeta(aMeta.getFileName(), Long.toString(aMeta.getFileSize()), Times.format(aMeta.getLastModifiedTime()));
                        }
                        containersLogMeta.add(meta);
                    }
                    continue;
                }
                if (logMeta.getContainerLogMeta(containerIdStr) == null) continue;
                ContainerLogMeta meta = new ContainerLogMeta(containerIdStr, curNodeId);
                for (IndexedFileLogMeta log : logMeta.getContainerLogMeta(containerIdStr)) {
                    meta.addLogMeta(log.getFileName(), Long.toString(log.getFileSize()), Times.format(log.getLastModifiedTime()));
                }
                containersLogMeta.add(meta);
            }
        }
        Collections.sort(containersLogMeta, new Comparator<ContainerLogMeta>(){

            @Override
            public int compare(ContainerLogMeta o1, ContainerLogMeta o2) {
                return o1.getContainerId().compareTo(o2.getContainerId());
            }
        });
        return containersLogMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public Map<String, Long> parseCheckSumFiles(List<FileStatus> fileList) throws IOException {
        HashMap<String, Long> checkSumFiles = new HashMap<String, Long>();
        Set status = new HashSet<FileStatus>(fileList).stream().filter(next -> next.getPath().getName().endsWith(CHECK_SUM_FILE_SUFFIX)).collect(Collectors.toSet());
        FileContext fc = null;
        for (FileStatus file : status) {
            FSDataInputStream checksumFileInputStream;
            block8: {
                long index;
                String nodeName;
                block7: {
                    int nameLength;
                    byte[] b;
                    checksumFileInputStream = null;
                    if (fc == null) {
                        fc = FileContext.getFileContext(file.getPath().toUri(), this.conf);
                    }
                    nodeName = null;
                    index = 0L;
                    checksumFileInputStream = fc.open(file.getPath());
                    int actualLength = checksumFileInputStream.read(b = new byte[nameLength = checksumFileInputStream.readInt()]);
                    if (actualLength != nameLength) break block7;
                    nodeName = new String(b, Charset.forName("UTF-8"));
                    index = checksumFileInputStream.readLong();
                }
                IOUtils.cleanupWithLogger(LOG, checksumFileInputStream);
                continue;
                try {
                    if (nodeName == null || nodeName.isEmpty()) break block8;
                    checkSumFiles.put(nodeName, index);
                }
                catch (IOException ex) {
                    try {
                        LOG.warn(ex.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtils.cleanupWithLogger(LOG, checksumFileInputStream);
                        throw throwable;
                    }
                    IOUtils.cleanupWithLogger(LOG, checksumFileInputStream);
                    continue;
                }
            }
            IOUtils.cleanupWithLogger(LOG, checksumFileInputStream);
        }
        return checkSumFiles;
    }

    @InterfaceAudience.Private
    public List<FileStatus> getNodeLogFileToRead(List<FileStatus> nodeFiles, String nodeId, ApplicationId appId) throws IOException {
        ArrayList<FileStatus> listOfFiles = new ArrayList<FileStatus>();
        for (FileStatus thisNodeFile : nodeFiles) {
            String nodeName = thisNodeFile.getPath().getName();
            if (nodeId != null && !nodeId.isEmpty() && !nodeName.contains(LogAggregationUtils.getNodeString(nodeId)) || nodeName.endsWith(".tmp") || nodeName.endsWith(CHECK_SUM_FILE_SUFFIX)) continue;
            listOfFiles.add(thisNodeFile);
        }
        return listOfFiles;
    }

    private List<FileStatus> getAllNodeFiles(RemoteIterator<FileStatus> nodeFiles, ApplicationId appId) throws IOException {
        ArrayList<FileStatus> listOfFiles = new ArrayList<FileStatus>();
        while (nodeFiles != null && nodeFiles.hasNext()) {
            FileStatus thisNodeFile = nodeFiles.next();
            String nodeName = thisNodeFile.getPath().getName();
            if (nodeName.equals(appId + ".har")) {
                Path p = new Path("har:///" + thisNodeFile.getPath().toUri().getRawPath());
                nodeFiles = HarFs.get(p.toUri(), this.conf).listStatusIterator(p);
                continue;
            }
            listOfFiles.add(thisNodeFile);
        }
        return listOfFiles;
    }

    @InterfaceAudience.Private
    public FileStatus getAllChecksumFiles(Map<String, FileStatus> fileMap, String fileName) {
        for (Map.Entry<String, FileStatus> file : fileMap.entrySet()) {
            if (!file.getKey().startsWith(fileName) || !file.getKey().endsWith(CHECK_SUM_FILE_SUFFIX)) continue;
            return file.getValue();
        }
        return null;
    }

    @Override
    public void renderAggregatedLogsBlock(HtmlBlock.Block html, View.ViewContext context) {
        IndexedFileAggregatedLogsBlock block = new IndexedFileAggregatedLogsBlock(context, this.conf, this);
        block.render(html);
    }

    @Override
    public String getApplicationOwner(Path aggregatedLogPath, ApplicationId appId) throws IOException {
        if (this.cachedIndexedLogsMeta == null || !this.cachedIndexedLogsMeta.getRemoteLogPath().equals(aggregatedLogPath)) {
            this.cachedIndexedLogsMeta = new CachedIndexedLogsMeta(this.loadIndexedLogsMeta(aggregatedLogPath, appId), aggregatedLogPath);
        }
        return this.cachedIndexedLogsMeta.getCachedIndexedLogsMeta().getUser();
    }

    @Override
    public Map<ApplicationAccessType, String> getApplicationAcls(Path aggregatedLogPath, ApplicationId appId) throws IOException {
        if (this.cachedIndexedLogsMeta == null || !this.cachedIndexedLogsMeta.getRemoteLogPath().equals(aggregatedLogPath)) {
            this.cachedIndexedLogsMeta = new CachedIndexedLogsMeta(this.loadIndexedLogsMeta(aggregatedLogPath, appId), aggregatedLogPath);
        }
        return this.cachedIndexedLogsMeta.getCachedIndexedLogsMeta().getAcls();
    }

    @Override
    public Path getRemoteAppLogDir(ApplicationId appId, String user) throws IOException {
        return LogAggregationUtils.getRemoteAppLogDir(this.conf, appId, user, this.remoteRootLogDir, this.remoteRootLogDirSuffix);
    }

    @Override
    public Path getOlderRemoteAppLogDir(ApplicationId appId, String user) throws IOException {
        return LogAggregationUtils.getOlderRemoteAppLogDir(this.conf, appId, user, this.remoteRootLogDir, this.remoteRootLogDirSuffix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public IndexedLogsMeta loadIndexedLogsMeta(Path remoteLogPath, long end, ApplicationId appId) throws IOException {
        FSDataInputStream fsDataIStream;
        FileContext fileContext;
        block8: {
            IndexedLogsMeta indexedLogsMeta;
            fileContext = FileContext.getFileContext(remoteLogPath.toUri(), this.conf);
            fsDataIStream = null;
            try {
                fsDataIStream = fileContext.open(remoteLogPath);
                if (end != 0L) break block8;
                indexedLogsMeta = null;
            }
            catch (Throwable throwable) {
                IOUtils.cleanupWithLogger(LOG, fsDataIStream);
                throw throwable;
            }
            IOUtils.cleanupWithLogger(LOG, fsDataIStream);
            return indexedLogsMeta;
        }
        long fileLength = end < 0L ? fileContext.getFileStatus(remoteLogPath).getLen() : end;
        fsDataIStream.seek(fileLength - 4L - 32L);
        int offset = fsDataIStream.readInt();
        if (offset > 0x4000000) {
            LOG.warn("The log meta size read from " + remoteLogPath + " is " + offset);
        }
        byte[] uuidRead = new byte[32];
        int uuidReadLen = fsDataIStream.read(uuidRead);
        if (this.uuid == null) {
            this.uuid = this.createUUID(appId);
        }
        if (uuidReadLen != 32 || !Arrays.equals(this.uuid, uuidRead)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("the length of loaded UUID:{}", (Object)uuidReadLen);
                LOG.debug("the loaded UUID:{}", (Object)new String(uuidRead, Charset.forName("UTF-8")));
                LOG.debug("the expected UUID:{}", (Object)new String(this.uuid, Charset.forName("UTF-8")));
            }
            throw new IOException("The UUID from " + remoteLogPath + " is not correct. The offset of loaded UUID is " + (fileLength - 32L));
        }
        byte[] array = new byte[offset];
        fsDataIStream.seek(fileLength - (long)offset - 4L - 32L);
        fsDataIStream.readFully(array);
        int actual = array.length;
        if (actual != offset) {
            throw new IOException("Error on loading log meta from " + remoteLogPath);
        }
        IndexedLogsMeta indexedLogsMeta = (IndexedLogsMeta)SerializationUtils.deserialize((byte[])array);
        IOUtils.cleanupWithLogger(LOG, fsDataIStream);
        return indexedLogsMeta;
    }

    private IndexedLogsMeta loadIndexedLogsMeta(Path remoteLogPath, ApplicationId appId) throws IOException {
        return this.loadIndexedLogsMeta(remoteLogPath, -1L, appId);
    }

    private static String logErrorMessage(File logFile, Exception e) {
        String message = "Error aggregating log file. Log file : " + logFile.getAbsolutePath() + ". " + e.getMessage();
        LOG.error(message, (Throwable)e);
        return message;
    }

    @InterfaceAudience.Private
    public static int getFSOutputBufferSize(Configuration conf) {
        return conf.getInt(FS_OUTPUT_BUF_SIZE_ATTR, 262144);
    }

    @InterfaceAudience.Private
    public static int getFSInputBufferSize(Configuration conf) {
        return conf.getInt(FS_INPUT_BUF_SIZE_ATTR, 262144);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public long getRollOverLogMaxSize(Configuration conf) {
        boolean supportAppend = false;
        try {
            FileSystem fs = FileSystem.get(this.remoteRootLogDir.toUri(), conf);
            if (fs instanceof LocalFileSystem || fs.hasPathCapability(this.remoteRootLogDir, "fs.capability.paths.append")) {
                supportAppend = true;
            }
        }
        catch (Exception ioe) {
            LOG.warn("Unable to determine if the filesystem supports append operation", (Throwable)ioe);
        }
        if (supportAppend) {
            return 0x40000000L * (long)conf.getInt(LOG_ROLL_OVER_MAX_FILE_SIZE_GB, 10);
        }
        return 0L;
    }

    private Path getCurrentRemoteLogFile(FileContext fc, Path parent, String nodeId) throws IOException {
        RemoteIterator<FileStatus> files = fc.listStatus(parent);
        long maxTime = 0L;
        Path returnPath = null;
        while (files.hasNext()) {
            FileStatus candidate = files.next();
            String fileName = candidate.getPath().getName();
            if (!fileName.contains(LogAggregationUtils.getNodeString(nodeId)) || fileName.endsWith(".tmp") || fileName.endsWith(CHECK_SUM_FILE_SUFFIX) || candidate.getModificationTime() <= maxTime) continue;
            maxTime = candidate.getModificationTime();
            returnPath = candidate.getPath();
        }
        return returnPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadUUIDFromLogFile(FileContext fc, Path parent, ApplicationId appId, String nodeId) throws Exception {
        byte[] id = null;
        RemoteIterator<FileStatus> files = fc.listStatus(parent);
        FSDataInputStream fsDataInputStream = null;
        byte[] uuid = this.createUUID(appId);
        while (files.hasNext()) {
            block4: {
                try {
                    byte[] b;
                    Path checkPath = files.next().getPath();
                    if (!checkPath.getName().contains(LogAggregationUtils.getNodeString(nodeId)) || checkPath.getName().endsWith(CHECK_SUM_FILE_SUFFIX)) break block4;
                    fsDataInputStream = fc.open(checkPath);
                    int actual = fsDataInputStream.read(b = new byte[uuid.length]);
                    if (actual != uuid.length || Arrays.equals(b, uuid)) {
                        this.deleteFileWithRetries(fc, checkPath);
                        break block4;
                    }
                    if (id != null) break block4;
                    id = uuid;
                }
                catch (Throwable throwable) {
                    IOUtils.cleanupWithLogger(LOG, fsDataInputStream);
                    throw throwable;
                }
            }
            IOUtils.cleanupWithLogger(LOG, fsDataInputStream);
        }
        return id == null ? uuid : id;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean isRollover(FileContext fc, Path candidate) throws IOException {
        FileStatus fs = fc.getFileStatus(candidate);
        return fs.getLen() >= this.logRollOverMaxFileSize;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public Clock getSystemClock() {
        return SystemClock.getInstance();
    }

    private byte[] createUUID(ApplicationId appId) throws IOException {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(appId.toString().getBytes(Charset.forName("UTF-8")));
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IOException(ex);
        }
    }

    static /* synthetic */ byte[] access$802(LogAggregationIndexedFileController x0, byte[] x1) {
        x0.uuid = x1;
        return x1;
    }

    private abstract class FSAction<T> {
        private FSAction() {
        }

        abstract T run() throws Exception;

        T runWithRetries() throws Exception {
            int retry = 0;
            while (true) {
                try {
                    return this.run();
                }
                catch (IOException e) {
                    LOG.info("Exception while executing an FS operation.", (Throwable)e);
                    if (++retry > LogAggregationIndexedFileController.this.fsNumRetries) {
                        LOG.info("Maxed out FS retries. Giving up!");
                        throw e;
                    }
                    LOG.info("Retrying operation on FS. Retry no. " + retry);
                    Thread.sleep(LogAggregationIndexedFileController.this.fsRetryInterval);
                    continue;
                }
                break;
            }
        }
    }

    private static class CachedIndexedLogsMeta {
        private final Path remoteLogPath;
        private final IndexedLogsMeta indexedLogsMeta;

        CachedIndexedLogsMeta(IndexedLogsMeta indexedLogsMeta, Path remoteLogPath) {
            this.indexedLogsMeta = indexedLogsMeta;
            this.remoteLogPath = remoteLogPath;
        }

        public Path getRemoteLogPath() {
            return this.remoteLogPath;
        }

        public IndexedLogsMeta getCachedIndexedLogsMeta() {
            return this.indexedLogsMeta;
        }
    }

    private static class IndexedFileOutputStreamState {
        private final Compression.Algorithm compressAlgo;
        private Compressor compressor;
        private final FSDataOutputStream fsOut;
        private long posStart;
        private final SimpleBufferedOutputStream fsBufferedOutput;
        private OutputStream out;
        private long offset;

        IndexedFileOutputStreamState(Compression.Algorithm compressionName, FSDataOutputStream fsOut, Configuration conf, long offset) throws IOException {
            this.compressAlgo = compressionName;
            this.fsOut = fsOut;
            this.offset = offset;
            this.posStart = fsOut.getPos();
            BytesWritable fsOutputBuffer = new BytesWritable();
            fsOutputBuffer.setCapacity(LogAggregationIndexedFileController.getFSOutputBufferSize(conf));
            this.fsBufferedOutput = new SimpleBufferedOutputStream(this.fsOut, fsOutputBuffer.getBytes());
            this.compressor = this.compressAlgo.getCompressor();
            try {
                this.out = this.compressAlgo.createCompressionStream(this.fsBufferedOutput, this.compressor, 0);
            }
            catch (IOException e) {
                LOG.warn(e.getMessage());
                this.compressAlgo.returnCompressor(this.compressor);
                throw e;
            }
        }

        OutputStream getOutputStream() {
            return this.out;
        }

        long getCurrentPos() throws IOException {
            return this.fsOut.getPos() + (long)this.fsBufferedOutput.size();
        }

        long getStartPos() {
            return this.posStart + this.offset;
        }

        long getCompressedSize() throws IOException {
            long ret = this.getCurrentPos() - this.posStart;
            return ret;
        }

        void finish() throws IOException {
            try {
                if (this.out != null) {
                    this.out.flush();
                    this.out = null;
                }
            }
            finally {
                this.compressAlgo.returnCompressor(this.compressor);
                this.compressor = null;
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static class IndexedFileLogMeta
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String containerId;
        private String fileName;
        private long fileSize;
        private long fileCompressedSize;
        private long lastModifiedTime;
        private long startIndex;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public void setFileSize(long fileSize) {
            this.fileSize = fileSize;
        }

        public long getFileCompressedSize() {
            return this.fileCompressedSize;
        }

        public void setFileCompressedSize(long fileCompressedSize) {
            this.fileCompressedSize = fileCompressedSize;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public long getStartIndex() {
            return this.startIndex;
        }

        public void setStartIndex(long startIndex) {
            this.startIndex = startIndex;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }
    }

    public static class IndexedPerAggregationLogMeta
    implements Serializable {
        private static final long serialVersionUID = 3929298383L;
        private String remoteNodeLogFileName;
        private Map<String, List<IndexedFileLogMeta>> logMetas = new HashMap<String, List<IndexedFileLogMeta>>();
        private long uploadTimeStamp;

        public String getRemoteNodeFile() {
            return this.remoteNodeLogFileName;
        }

        public void setRemoteNodeFile(String remoteNodeLogFileName) {
            this.remoteNodeLogFileName = remoteNodeLogFileName;
        }

        public void addContainerLogMeta(String containerId, List<IndexedFileLogMeta> logMeta) {
            this.logMetas.put(containerId, logMeta);
        }

        public List<IndexedFileLogMeta> getContainerLogMeta(String containerId) {
            return this.logMetas.get(containerId);
        }

        public Map<String, List<IndexedFileLogMeta>> getLogMetas() {
            return this.logMetas;
        }

        public long getUploadTimeStamp() {
            return this.uploadTimeStamp;
        }

        public void setUploadTimeStamp(long uploadTimeStamp) {
            this.uploadTimeStamp = uploadTimeStamp;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static class IndexedLogsMeta
    implements Serializable {
        private static final long serialVersionUID = 5439875373L;
        private int version;
        private String user;
        private String compressName;
        private Map<ApplicationAccessType, String> acls;
        private String nodeId;
        private List<IndexedPerAggregationLogMeta> logMetas = new ArrayList<IndexedPerAggregationLogMeta>();

        public int getVersion() {
            return this.version;
        }

        public void setVersion(int version) {
            this.version = version;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public Map<ApplicationAccessType, String> getAcls() {
            return this.acls;
        }

        public void setAcls(Map<ApplicationAccessType, String> acls) {
            this.acls = acls;
        }

        public String getCompressName() {
            return this.compressName;
        }

        public void setCompressName(String compressName) {
            this.compressName = compressName;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public void addLogMeta(IndexedPerAggregationLogMeta logMeta) {
            this.logMetas.add(logMeta);
        }

        public List<IndexedPerAggregationLogMeta> getLogMetas() {
            return this.logMetas;
        }
    }
}

