/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.NormsProducer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.util.io.IOUtils;
import org.opensearch.neuralsearch.sparse.cache.ClusteredPostingCache;
import org.opensearch.neuralsearch.sparse.codec.ClusteredPostingTermsWriter;
import org.opensearch.neuralsearch.sparse.codec.CodecUtilWrapper;
import org.opensearch.neuralsearch.sparse.codec.MergeHelper;
import org.opensearch.neuralsearch.sparse.codec.SparsePostingsReader;
import org.opensearch.neuralsearch.sparse.codec.SparseTermsLuceneWriter;
import org.opensearch.neuralsearch.sparse.common.MergeStateFacade;
import org.opensearch.neuralsearch.sparse.common.PredicateUtils;
import org.opensearch.neuralsearch.sparse.mapper.SparseVectorField;

public class SparsePostingsConsumer
extends FieldsConsumer {
    @Generated
    private static final Logger log = LogManager.getLogger(SparsePostingsConsumer.class);
    private final FieldsConsumer delegate;
    private final SegmentWriteState state;
    private final MergeHelper mergeHelper;
    static final String CODEC_NAME = "SparsePostingsProducer";
    private final IndexOutput termsOut;
    private final IndexOutput postingOut;
    private final SparseTermsLuceneWriter sparseTermsLuceneWriter;
    public static final int VERSION_START = 1;
    public static final int VERSION_CURRENT = 1;
    static final String TERMS_EXTENSION = "sit";
    static final String POSTING_EXTENSION = "sip";
    private final ClusteredPostingTermsWriter clusteredPostingTermsWriter;
    private long termsStartFp;
    private long postingStartFp;
    private boolean fromMerge;

    public SparsePostingsConsumer(@NonNull FieldsConsumer delegate, @NonNull SegmentWriteState state, @NonNull MergeHelper mergeHelper) throws IOException {
        this(delegate, state, mergeHelper, 1, new ClusteredPostingTermsWriter(CODEC_NAME, 1, new CodecUtilWrapper()), new SparseTermsLuceneWriter(CODEC_NAME, 1, new CodecUtilWrapper()));
        Objects.requireNonNull(delegate, "delegate is marked non-null but is null");
        Objects.requireNonNull(state, "state is marked non-null but is null");
        Objects.requireNonNull(mergeHelper, "mergeHelper is marked non-null but is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SparsePostingsConsumer(@NonNull FieldsConsumer delegate, @NonNull SegmentWriteState state, @NonNull MergeHelper mergeHelper, int version, ClusteredPostingTermsWriter termsWriter, SparseTermsLuceneWriter luceneWriter) throws IOException {
        block5: {
            IndexOutput postingOut;
            IndexOutput termsOut;
            block4: {
                this.termsStartFp = 0L;
                this.postingStartFp = 0L;
                this.fromMerge = false;
                Objects.requireNonNull(delegate, "delegate is marked non-null but is null");
                Objects.requireNonNull(state, "state is marked non-null but is null");
                Objects.requireNonNull(mergeHelper, "mergeHelper is marked non-null but is null");
                this.delegate = delegate;
                this.state = state;
                this.mergeHelper = mergeHelper;
                this.clusteredPostingTermsWriter = termsWriter;
                this.sparseTermsLuceneWriter = luceneWriter;
                String termsFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)TERMS_EXTENSION);
                String postingFileName = IndexFileNames.segmentFileName((String)state.segmentInfo.name, (String)state.segmentSuffix, (String)POSTING_EXTENSION);
                boolean success = false;
                termsOut = null;
                postingOut = null;
                try {
                    termsOut = state.directory.createOutput(termsFileName, state.context);
                    this.sparseTermsLuceneWriter.init(termsOut, state);
                    postingOut = state.directory.createOutput(postingFileName, state.context);
                    this.clusteredPostingTermsWriter.init(postingOut, state);
                    success = true;
                    if (success) break block4;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{termsOut, postingOut});
                        this.termsOut = null;
                        this.postingOut = null;
                    } else {
                        this.termsOut = termsOut;
                        this.postingOut = postingOut;
                        this.termsStartFp = termsOut.getFilePointer();
                        this.postingStartFp = postingOut.getFilePointer();
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{termsOut, postingOut});
                this.termsOut = null;
                this.postingOut = null;
                break block5;
            }
            this.termsOut = termsOut;
            this.postingOut = postingOut;
            this.termsStartFp = termsOut.getFilePointer();
            this.postingStartFp = postingOut.getFilePointer();
        }
    }

    private void writeSparseTerms(Fields fields, NormsProducer norms, List<String> sparseFields) throws IOException {
        this.sparseTermsLuceneWriter.writeFieldCount(sparseFields.size());
        String lastField = null;
        for (String field : sparseFields) {
            BytesRef term;
            assert (lastField == null || lastField.compareTo(field) < 0);
            lastField = field;
            this.sparseTermsLuceneWriter.writeFieldNumber(this.state.fieldInfos.fieldInfo((String)field).number);
            Terms terms = fields.terms(field);
            if (terms == null) {
                this.sparseTermsLuceneWriter.writeTermsSize(0L);
                continue;
            }
            this.clusteredPostingTermsWriter.setFieldAndMaxDoc(this.state.fieldInfos.fieldInfo(field), this.state.segmentInfo.maxDoc(), false);
            TermsEnum termsEnum = terms.iterator();
            ArrayList<BytesRef> termsList = new ArrayList<BytesRef>();
            ArrayList<BlockTermState> states = new ArrayList<BlockTermState>();
            while ((term = termsEnum.next()) != null) {
                BytesRef clonedTerm = term.clone();
                BlockTermState state = this.clusteredPostingTermsWriter.write(clonedTerm, termsEnum, norms);
                termsList.add(clonedTerm);
                states.add(state);
            }
            this.sparseTermsLuceneWriter.writeTermsSize(termsList.size());
            for (int i = 0; i < termsList.size(); ++i) {
                this.sparseTermsLuceneWriter.writeTerm((BytesRef)termsList.get(i), (BlockTermState)states.get(i));
            }
        }
    }

    public void write(Fields fields, NormsProducer norms) throws IOException {
        final ArrayList<String> nonSparseFields = new ArrayList<String>();
        ArrayList<String> sparseFields = new ArrayList<String>();
        for (String field : fields) {
            FieldInfo fieldInfo = this.state.fieldInfos.fieldInfo(field);
            if (SparseVectorField.isSparseField(fieldInfo) && PredicateUtils.shouldRunSeisPredicate.test(this.state.segmentInfo, fieldInfo)) {
                sparseFields.add(field);
                continue;
            }
            nonSparseFields.add(field);
        }
        if (!nonSparseFields.isEmpty()) {
            FilterLeafReader.FilterFields maskedFields = new FilterLeafReader.FilterFields(this, fields){

                public Iterator<String> iterator() {
                    return nonSparseFields.iterator();
                }
            };
            this.delegate.write((Fields)maskedFields, norms);
        }
        if (!this.fromMerge && !sparseFields.isEmpty()) {
            this.writeSparseTerms(fields, norms, sparseFields);
        }
    }

    public void merge(MergeState mergeState, NormsProducer norms) throws IOException {
        this.fromMerge = true;
        super.merge(mergeState, norms);
        try {
            MergeStateFacade mergeStateFacade = this.mergeHelper.convertToMergeStateFacade(mergeState);
            SparsePostingsReader sparsePostingsReader = new SparsePostingsReader(mergeStateFacade, this.mergeHelper);
            sparsePostingsReader.merge(this.sparseTermsLuceneWriter, this.clusteredPostingTermsWriter);
            this.mergeHelper.clearCacheData(mergeStateFacade, null, ClusteredPostingCache.getInstance()::onIndexRemoval);
        }
        catch (Exception e) {
            log.error("Merge sparse postings error", (Throwable)e);
        }
    }

    public void close() throws IOException {
        block5: {
            block4: {
                this.delegate.close();
                boolean success = false;
                try {
                    this.sparseTermsLuceneWriter.close(this.termsStartFp);
                    this.clusteredPostingTermsWriter.close(this.postingStartFp);
                    success = true;
                    if (!success) break block4;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{this.termsOut, this.postingOut});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.termsOut, this.postingOut});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{this.termsOut, this.postingOut});
                break block5;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{this.termsOut, this.postingOut});
        }
    }
}

