/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.core.common.logging;

import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class LoggerMessageFormat {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    public static String format(String messagePattern, Object ... argArray) {
        return LoggerMessageFormat.format(null, messagePattern, argArray);
    }

    public static String format(String prefix, String messagePattern, Object ... argArray) {
        if (messagePattern == null) {
            return null;
        }
        if (argArray == null || argArray.length == 0) {
            if (prefix == null) {
                return messagePattern;
            }
            return prefix + messagePattern;
        }
        int i = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        if (prefix != null) {
            sbuf.append(prefix);
        }
        for (int L = 0; L < argArray.length; ++L) {
            int j = messagePattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    return messagePattern;
                }
                sbuf.append(messagePattern.substring(i));
                return sbuf.toString();
            }
            if (LoggerMessageFormat.isEscapedDelimiter(messagePattern, j)) {
                if (!LoggerMessageFormat.isDoubleEscaped(messagePattern, j)) {
                    --L;
                    sbuf.append(messagePattern, i, j - 1);
                    sbuf.append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(messagePattern, i, j - 1);
                LoggerMessageFormat.deeplyAppendParameter(sbuf, argArray[L], new HashSet<Object[]>());
                i = j + 2;
                continue;
            }
            sbuf.append(messagePattern, i, j);
            LoggerMessageFormat.deeplyAppendParameter(sbuf, argArray[L], new HashSet<Object[]>());
            i = j + 2;
        }
        sbuf.append(messagePattern.substring(i));
        return sbuf.toString();
    }

    static boolean isEscapedDelimiter(String messagePattern, int delimiterStartIndex) {
        if (delimiterStartIndex == 0) {
            return false;
        }
        char potentialEscape = messagePattern.charAt(delimiterStartIndex - 1);
        return potentialEscape == '\\';
    }

    static boolean isDoubleEscaped(String messagePattern, int delimiterStartIndex) {
        return delimiterStartIndex >= 2 && messagePattern.charAt(delimiterStartIndex - 2) == '\\';
    }

    private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Set<Object[]> seen) {
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            LoggerMessageFormat.safeObjectAppend(sbuf, o);
        } else {
            Object object = o;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{boolean[].class, byte[].class, char[].class, short[].class, int[].class, long[].class, float[].class, double[].class}, (Object)object2, n)) {
                case 0: {
                    boolean[] boolArr = (boolean[])object2;
                    LoggerMessageFormat.booleanArrayAppend(sbuf, boolArr);
                    break;
                }
                case 1: {
                    byte[] byteArr = (byte[])object2;
                    LoggerMessageFormat.byteArrayAppend(sbuf, byteArr);
                    break;
                }
                case 2: {
                    char[] charArr = (char[])object2;
                    LoggerMessageFormat.charArrayAppend(sbuf, charArr);
                    break;
                }
                case 3: {
                    short[] shortArr = (short[])object2;
                    LoggerMessageFormat.shortArrayAppend(sbuf, shortArr);
                    break;
                }
                case 4: {
                    int[] intArr = (int[])object2;
                    LoggerMessageFormat.intArrayAppend(sbuf, intArr);
                    break;
                }
                case 5: {
                    long[] longArr = (long[])object2;
                    LoggerMessageFormat.longArrayAppend(sbuf, longArr);
                    break;
                }
                case 6: {
                    float[] floatArr = (float[])object2;
                    LoggerMessageFormat.floatArrayAppend(sbuf, floatArr);
                    break;
                }
                case 7: {
                    double[] doubleArr = (double[])object2;
                    LoggerMessageFormat.doubleArrayAppend(sbuf, doubleArr);
                    break;
                }
                default: {
                    LoggerMessageFormat.objectArrayAppend(sbuf, (Object[])o, seen);
                }
            }
        }
    }

    private static void safeObjectAppend(StringBuilder sbuf, Object o) {
        try {
            String oAsString = o.toString();
            sbuf.append(oAsString);
        }
        catch (Exception e) {
            sbuf.append("[FAILED toString()]");
        }
    }

    private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Set<Object[]> seen) {
        sbuf.append('[');
        if (!seen.contains(a)) {
            seen.add(a);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                LoggerMessageFormat.deeplyAppendParameter(sbuf, a[i], seen);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            seen.remove(a);
        } else {
            sbuf.append("...");
        }
        sbuf.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(']');
    }
}

