/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rule;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opensearch.rule.RuleRoutingService;
import org.opensearch.rule.autotagging.FeatureType;

public class RuleRoutingServiceRegistry {
    private final Map<String, RuleRoutingService> ruleRoutingServices = new ConcurrentHashMap<String, RuleRoutingService>();

    public void register(FeatureType featureType, RuleRoutingService ruleRoutingService) {
        if (this.ruleRoutingServices.put(featureType.getName(), ruleRoutingService) != null) {
            throw new IllegalArgumentException("Duplicate rule routing service: " + featureType.getName());
        }
    }

    public RuleRoutingService getRuleRoutingService(FeatureType featureType) {
        if (!this.ruleRoutingServices.containsKey(featureType.getName())) {
            throw new IllegalArgumentException("Unknown feature type for routing service: " + featureType.getName());
        }
        return this.ruleRoutingServices.get(featureType.getName());
    }
}

